/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.registration;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.createmod.ponder.Ponder;
import net.createmod.ponder.api.registration.TagRegistryAccess;
import net.createmod.ponder.foundation.PonderTag;
import net.createmod.ponder.foundation.registration.PonderLocalization;
import net.minecraft.class_1802;
import net.minecraft.class_2960;

public class PonderTagRegistry
implements TagRegistryAccess {
    private final PonderLocalization localization;
    private final Multimap<class_2960, class_2960> componentTagMap;
    private final Map<class_2960, PonderTag> registeredTags;
    private final List<PonderTag> listedTags;
    private final PonderTag MISSING = new PonderTag(Ponder.asResource("not_registered"), null, class_1802.field_8077.method_7854(), class_1802.field_8077.method_7854());
    private boolean allowRegistration = true;

    public PonderTagRegistry(PonderLocalization localization) {
        this.localization = localization;
        this.componentTagMap = LinkedHashMultimap.create();
        this.registeredTags = new HashMap<class_2960, PonderTag>();
        this.listedTags = new ArrayList<PonderTag>();
    }

    public void clearRegistry() {
        this.componentTagMap.clear();
        this.listedTags.clear();
        this.allowRegistration = true;
    }

    public void registerTag(PonderTag tag) {
        if (!this.allowRegistration) {
            throw new IllegalStateException("Registration Phase has already ended!");
        }
        this.registeredTags.put(tag.getId(), tag);
    }

    public void listTag(PonderTag tag) {
        if (!this.allowRegistration) {
            throw new IllegalStateException("Registration Phase has already ended!");
        }
        this.listedTags.add(tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTagToComponent(class_2960 tag, class_2960 item) {
        if (!this.allowRegistration) {
            throw new IllegalStateException("Registration Phase has already ended!");
        }
        Multimap<class_2960, class_2960> multimap = this.componentTagMap;
        synchronized (multimap) {
            this.componentTagMap.put((Object)item, (Object)tag);
        }
    }

    @Override
    public PonderTag getRegisteredTag(class_2960 tagLocation) {
        return this.registeredTags.getOrDefault(tagLocation, this.MISSING);
    }

    @Override
    public List<PonderTag> getListedTags() {
        return this.listedTags;
    }

    @Override
    public Set<PonderTag> getTags(class_2960 item) {
        return this.componentTagMap.get((Object)item).stream().map(this::getRegisteredTag).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<class_2960> getItems(class_2960 tag) {
        return (Set)this.componentTagMap.entries().stream().filter(e -> ((class_2960)e.getValue()).equals((Object)tag)).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public Set<class_2960> getItems(PonderTag tag) {
        return this.getItems(tag.getId());
    }
}

